IF EXISTS (SELECT * FROM sys.views 
		  WHERE object_id = OBJECT_ID(N'[dbo].[V_TRILHO_PROD_NECESSIDADE_ATENDIMENTO]'))
begin
	DROP VIEW [dbo].[V_TRILHO_PROD_NECESSIDADE_ATENDIMENTO]
end

GO
/****** Object:  View [dbo].[V_TRILHO_PROD_NECESSIDADE_ATENDIMENTO]    Script Date: 11/09/2017 17:43:28 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_TRILHO_PROD_NECESSIDADE_ATENDIMENTO]
AS
SELECT TOP 100 PERCENT 
	E.CD_EMP, 
	E.CD_FILIAL AS FILIAL_ORIG, 
	N.CD_FILIAL AS FILIAL_DEST, 
	E.CD_EXCESSO_MAQ,
	SUM (N.NECESSIDADE ) NECESSIDADE,
	SUM (CASE WHEN E.EXCESSO > N.NECESSIDADE THEN
			N.NECESSIDADE
		WHEN E.EXCESSO < N.NECESSIDADE THEN
			E.EXCESSO
		ELSE
			N.NECESSIDADE 
	END) QT_ATEND,
	(SUM(CASE WHEN E.EXCESSO > N.NECESSIDADE THEN
				N.NECESSIDADE
			WHEN E.EXCESSO < N.NECESSIDADE THEN
				E.EXCESSO
			ELSE
				N.NECESSIDADE 
			END)/ SUM(NECESSIDADE) * 100 ) AS PERC_ATEND,

	SUM(CASE WHEN e.EXCESSO > NECESSIDADE THEN n.NECESSIDADE * e.VLR_CUSTO
		    WHEN e.EXCESSO < n.NECESSIDADE THEN e.EXCESSO *	    e.VLR_CUSTO
			 ELSE n.NECESSIDADE * e.VLR_CUSTO END) VLR_ATEND

FROM         
	dbo.TRILHO_MAQ_EXCESSO AS E 
	INNER JOIN dbo.V_TRILHO_PROD_NECESSIDADE AS N ON 
	E.CD_EMP  = N.CD_EMP AND
	E.DT_MOV  = N.DT_MOV AND 
    E.CD_PROD = N.CD_PROD

WHERE     
	E.CD_EMP = 1
	AND E.CD_FILIAL <>	N.CD_FILIAL	
GROUP BY 
	E.CD_EMP, 
	E.CD_FILIAL, 
	E.CD_EXCESSO_MAQ,
	N.CD_FILIAL
GO


